define("core/local/aria/aria-hidden",["exports","core/normalise","./selectors"],(function(_exports,_normalise,_selectors){var obj;
/**
   * ARIA helpers related to the aria-hidden attribute.
   *
   * @module     core/local/aria/aria-hidden.
   * @copyright  2020 Andrew Nicols <andrew@nicols.co.uk>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.unhideSiblings=_exports.unhide=_exports.hideSiblings=_exports.hide=void 0,_selectors=(obj=_selectors)&&obj.__esModule?obj:{default:obj};var childObserverMap=new Map,siblingObserverMap=new Map,supportsMutationObservers=function(){return MutationObserver&&"function"==typeof MutationObserver},disableElementFocusability=function(target){target instanceof HTMLElement&&(target.matches(_selectors.default.elements.focusable)&&disableAndStoreTabIndex(target),target.querySelectorAll(_selectors.default.elements.focusable).forEach(disableAndStoreTabIndex))},disableAndStoreTabIndex=function(element){void 0===element.dataset.ariaHiddenTabIndex&&(element.getAttribute("tabindex")?element.dataset.ariaHiddenTabIndex=element.getAttribute("tabindex"):element.dataset.ariaHiddenTabIndex="",element.setAttribute("tabindex",-1))},restoreTabIndex=function(element){if(!element.closest(_selectors.default.aria.hidden)){var oldTabIndex=element.dataset.ariaHiddenTabIndex;""===oldTabIndex?element.removeAttribute("tabindex"):element.setAttribute("tabindex",oldTabIndex),delete element.dataset.ariaHiddenTabIndex}},hide=function(target){return(0,_normalise.getList)(target).forEach(_hide)};_exports.hide=hide;var _hide=function(target){if(target instanceof HTMLElement&&!target.closest(_selectors.default.aria.hidden)&&(target.setAttribute("aria-hidden",!0),disableElementFocusability(target),supportsMutationObservers())){var newNodeObserver=new MutationObserver((function(mutationList){mutationList.forEach((function(mutation){mutation.addedNodes.forEach(disableElementFocusability)}))}));newNodeObserver.observe(target,{childList:!0,subtree:!0}),childObserverMap.set(target,newNodeObserver)}},unhide=function(target){return(0,_normalise.getList)(target).forEach(_unhide)};_exports.unhide=unhide;var _unhide=function(target){target instanceof HTMLElement&&(target.removeAttribute("aria-hidden"),function(target){target instanceof HTMLElement&&(target.matches(_selectors.default.elements.focusableToUnhide)&&restoreTabIndex(target),target.querySelectorAll(_selectors.default.elements.focusableToUnhide).forEach(restoreTabIndex))}(target),childObserverMap.has(target)&&(childObserverMap.get(target).disconnect(),childObserverMap.delete(target)))};_exports.hideSiblings=function(target){return(0,_normalise.getList)(target).forEach(_hideSiblings)};var _hideSiblings=function(target){if(target instanceof HTMLElement&&target.parentElement&&(target.parentElement.childNodes.forEach((function(node){node!==target&&hide(node)})),supportsMutationObservers())){var newNodeObserver=new MutationObserver((function(mutationList){mutationList.forEach((function(mutation){mutation.addedNodes.forEach((function(node){target.contains(node)||hide(node)}))}))}));newNodeObserver.observe(target.parentElement,{childList:!0,subtree:!0}),siblingObserverMap.set(target.parentElement,newNodeObserver)}};_exports.unhideSiblings=function(target){return(0,_normalise.getList)(target).forEach(_unhideSiblings)};var _unhideSiblings=function(target){target instanceof HTMLElement&&target.parentElement&&(target.parentElement.childNodes.forEach((function(node){node!==target&&unhide(node)})),siblingObserverMap.has(target.parentElement)&&(siblingObserverMap.get(target.parentElement).disconnect(),siblingObserverMap.delete(target.parentElement)))}}));

//# sourceMappingURL=aria-hidden.min.js.map